/*
 * Copyright 2022 Nico Sonack <nsonack@herrhotzenplotz.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef GITHUB_CHECKS_H
#define GITHUB_CHECKS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sn/sn.h>

typedef struct gcli_github_check  gcli_github_check;
typedef struct gcli_github_checks gcli_github_checks;

struct gcli_github_check {
	char *name;
	char *status;
	char *conclusion;
	char *started_at;
	char *completed_at;
	long  id;
};

struct gcli_github_checks {
	gcli_github_check *checks;
	size_t             checks_size;
};

void github_get_checks(char const *owner,
                       char const *repo,
                       char const *ref,
                       int max,
                       gcli_github_checks *checks);

void github_print_checks(gcli_github_checks const *checks);

void github_free_checks(gcli_github_checks *checks);

int github_checks(char const *owner,
                  char const *repo,
                  char const *ref,
                  int max);

#endif /* GITHUB_CHECKS_H */
